#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
using UnityEngine.Events;
#endregion

namespace GroundhogLearning.GameKit.Interactions
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_INTERACTIONS + "Interactable")]
    public class Interactable : MonoBehaviour
    {
        #region Variables

        [Header("Configuration")]

        [Tooltip("Determines whether this interactable can be activated.")]
        [SerializeField] private bool _isActivable;

        [Header("Events")]

        [Tooltip("Unity event triggered when the interactor enters the interactable.")]
        public UnityEvent OnEnter;

        [Tooltip("Unity event triggered while the interactor remains on the interactable.")]
        public UnityEvent OnStay;

        [Tooltip("Unity event triggered when the interactor exits the interactable.")]
        public UnityEvent OnExit;

        [Tooltip("Unity event triggered when the interactable is activated.")]
        public UnityEvent OnActivated;

        public bool IsEnabled { get { return _collider.enabled; } }

        protected Collider _collider;
        protected Rigidbody _rigidbody;

        #endregion

        protected virtual void Awake()
        {
            if (!TryGetComponent(out _collider))
            {
                Debug.LogError($"{gameObject.name} is missing a Collider");
            }

            if (!TryGetComponent(out _rigidbody))
            {
                Debug.LogWarning($"{gameObject.name} is missing a Rigidbody");
            }
        }
        protected virtual void Start()
        {

        }

        public void Enable(bool enable)
        {
            gameObject.SetActive(enable);
        }

        public virtual Interactable Activate(RayInteractor interactor)
        {
            Debug.Log($"{interactor.name} activated {gameObject.name}");
            OnActivated?.Invoke();
            return null;
        }

        public virtual void Enter(RayInteractor interactor)
        {
            Debug.Log($"{interactor.name} entered {gameObject.name}");
            OnEnter?.Invoke();
        }
        public virtual void Stay(RayInteractor interactor)
        {
            Debug.Log($"{interactor.name} stays on {gameObject.name}");
            OnStay?.Invoke();
        }
        public virtual void Exit(RayInteractor interactor)
        {
            Debug.Log($"{interactor.name} exited {gameObject.name}");
            OnExit?.Invoke();
        }
    }
}